const playerConfig = {
    // Default player settings
    defaultSettings: {
        volume: 0.8,
        isLive: false,
        muted: false,
        autoplay: false,
        pip: true,
        autoSize: true,
        autoMini: true,
        screenshot: true,
        setting: true,
        loop: false,
        flip: true,
        playbackRate: true,
        aspectRatio: true,
        fullscreen: true,
        fullscreenWeb: true,
        subtitleOffset: true,
        miniProgressBar: true,
        mutex: true,
        backdrop: true,
        playsInline: true,
        autoPlayback: false, // Disabled auto-playback notification
        airplay: true,
        theme: '#23ade5',
        lang: 'vi',
        whitelist: ['*'],
    },

    // Vietnamese language translation
    i18n: {
        'vi': {
            'Play': 'Phát',
            'Pause': 'Tạm dừng',
            'Mute': 'Tắt tiếng',
            'Unmute': 'Bật tiếng',
            'Screenshot': 'Chụp màn hình',
            'Settings': 'Cài đặt',
            'Fullscreen': 'Toàn màn hình',
            'Exit fullscreen': 'Thoát toàn màn hình',
            'Web fullscreen': 'Toàn màn hình web',
            'Exit web fullscreen': 'Thoát toàn màn hình web',
            'Loop': 'Lặp video',
            'Speed': 'Tốc độ',
            'Normal': 'Bình thường',
            'Quality': 'Chất lượng',
            'Flip': 'Lật video',
            'Horizontal': 'Ngang',
            'Vertical': 'Dọc',
            'Aspect ratio': 'Tỷ lệ khung hình',
            'Default': 'Mặc định',
            'Normal': 'Bình thường',
            'Original': 'Gốc',
            '16:9': '16:9',
            '4:3': '4:3',
        }
    },

    // Supported video types
    supportedTypes: {
        hls: ['m3u8'],
        mp4: ['mp4'],
        webm: ['webm']
    },

    // Allowed domains for CORS (add your domains here)
    allowedDomains: [
        'localhost',
        '127.0.0.1',
        's5.phim1280.tv'
    ],

    // Playback memory settings
    playbackMemory: {
        enabled: true,
        storageKey: 'video-progress',
        updateInterval: 5000, // Update progress every 5 seconds
    }
};

// Export the configuration
if (typeof module !== 'undefined' && module.exports) {
    module.exports = playerConfig;
} 